/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.util.Date;

import java.util.Collections;
import java.util.Comparator;

import java.util.List;

import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.NumberPart;
import jp.mosp.common.part.StringPart;
import jp.mosp.common.part.TimePart;

public class CommonUtility {

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @param falseflag falseԂ
	 * @return  ǂłȂꍇfalse
	 */
	public boolean convFlagToBoolean(String target, String trueflag, String falseflag) {
		return StringPart.convFlagToBoolean(target, trueflag, falseflag);
	}

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @return 
	 */
	public boolean convFlagToBoolean(String target, String trueflag) {
		return StringPart.convFlagToBoolean(target, trueflag);
	}

	/**
	 * tOϊiintbooleanj
	 * @param target Ώint
	 * @param trueflag trueԂ
	 * @return 
	 */
	public boolean convFlagToBoolean(int target, int trueflag) {
		return StringPart.convFlagToBoolean(target, trueflag);
	}

	/**
	 * tOϊibooleanStringj
	 * @param isTrue 	truȅꍇString
	 * @param isFalse	falsȅꍇString
	 * @param flag 		true or false
	 * @return	String 	ʖ
	 */
	public String returnStringFlag(String isTrue, String isFalse, boolean flag) {
		return StringPart.returnStringFlag(isTrue, isFalse, flag);
	}

	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truecOFFAfalsecON
	 */
	public String returnTrueIsOff(boolean flag) {
		return StringPart.returnTrueIsOff(flag);
	}

	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truecONAfalsecOFF
	 */
	public String returnTrueIsOn(boolean flag) {
		return StringPart.returnTrueIsOn(flag);
	}

	/**
	 * ̑݃`FbN
	 * @param value			ΏۃR[h
	 * @param aryTarget		Ώۖ̂܂ޔz
	 * @return
	 * <p>
	 * ݂̂ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public boolean checkNameExist(String value, String[][] aryTarget) {
		String target = getCodeName(value, aryTarget);
		if (target.equals(value)) {
			return false;
		}
		return true;
	}

	/**
	 * Xg̃\[g
	 * @param list		ΏۃXg
	 * @param comp		ΏComparator
	 */
	public void sortList(List<?> list, Comparator<Object> comp) {
		Collections.sort(list, comp);
	}

	/**
	 * Xg̃\[g
	 * @param list			ΏۃXg
	 * @param comp			ΏComparator
	 * @param isAscending	true...Afalse...~
	 */
	public void sortList(List<?> list, Comparator<Object> comp, boolean isAscending) {
		if (isAscending) {
			sortList(list, comp);
		} else {
			Collections.sort(list, Collections.reverseOrder(comp));
		}
	}

	/*֘A*/

	/**
	 * StringNullA`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0̏ꍇtrueAłȂꍇfalse</p>
	 */
	public boolean isNull(String str) {
		return StringPart.isNull(str);
	}

	/**
	 * StringNotNull`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0ȊȌꍇtrueAłȂꍇfalse</p>
	 */
	public boolean isNotNull(String str) {
		return StringPart.isNotNull(str);
	}

	/**
	 * z񁨃J}؂̕
	 * @param array		Ώۈꎟz
	 * @return
	 */
	public String convArrayToFormattedByComma(String[] array) {
		return StringPart.convArrayToFormattedByComma(array);
	}

	/**
	 * X֔ԍ\bh
	 * @param	code X֔ԍ
	 * @return O3
	 */
	public String divideYubinCodeForward(String code) {
		return StringPart.divideYubinCodeForward(code);
	}

	/**
	 * X֔ԍ\bh
	 * @param	code X֔ԍ
	 * @return 4
	 */
	public String divideYubinCodeBackward(String code) {
		return StringPart.divideYubinCodeBackward(code);
	}

	/**
	 * nCt\bh
	 * @param code Ώۃf[^
	 * @param hyphen nCt
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public String[] divideByHyphen(String code, int hyphen) {
		return StringPart.divideByHyphen(code, hyphen);
	}

	/**
	 * nCt\bh
	 * @param code Ώۃf[^
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB<br>
	 * nCtŕ񂪏IꍇAnCt̑O̕܂łA
	 * zɂB
	 */
	public String[] divideByHyphen(String code) {
		return StringPart.divideByHyphen(code);
	}

	/**
	 * J}\bh
	 * @param code Ώۃf[^
	 * @param comma J}
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public String[] divideByComma(String code, int comma) {
		return StringPart.divideByComma(code, comma);
	}

	/**
	 * J}\bh
	 * @param code Ώۃf[^
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 */
	public String[] divideByComma(String code) {
		return StringPart.divideByComma(code);
	}

	/**
	 * J}\bh
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	public String combineByComma(String[] array) {
		return StringPart.combineByComma(array);
	}

	/**
	 * XbV\bh
	 * @param code		ΏۃR[h
	 * @return@z
	 */
	public String[] divideBySlash(String code) {
		return StringPart.divideBySlash(code);
	}

	/**
	 * XbV\bh
	 * @param code		ΏۃR[h
	 * @param slash		XbV
	 * @return@z
	 */
	public String[] divideBySlash(String code, int slash) {
		return StringPart.divideBySlash(code, slash);
	}

	/**
	 * nullɏlZbg
	 * @param obj
	 * @param init
	 * @return	string ϊ
	 */
	public String convNullToInitialValue(Object obj, String init) {
		return StringPart.convNullToInitialValue(obj, init);
	}
	/**
	 * 𕪊
	 * @param Sspl1
	 * @param Sspl2
	 * @param Sspl3
	 * @return	
	 */
	public static String splitStrings(String Sspl1, String Sspl2, int Sspl3) {
		return StringPart.splitStrings(Sspl1, Sspl2, Sspl3);
	}

	/**
	 * tH[}bg
	 * @param number 
	 * @param max ő包
	 * @param min _ȉő包
	 * @return ()
	 */
	public String getNumberString(double number, int integer, int fraction) {
		return NumberPart.getNumberString(number, integer, fraction);
	}

	/**
	 * s\
	 * @param aStr sΏە
	 * @return s㕶
	 */
	public static String brHTML(String aStr) {
		return StringPart.brHTML(aStr);
	}

	/**
	 * [t̐琮֕ϊ
	 * @param number [t
	 * @return 
	 */
	public String removeZero(String number) {
		return StringPart.removeZero(number);
	}

	/**
	 * [t̐֕ϊ
	 * @param number
	 * @return String	i0~9ji00~09j
	 */
	public String addZero(int number) {
		return StringPart.addZero(number);
	}

	/**
	 * [t̐֕ϊ
	 * @param number
	 * @return String	i0~9ji00~09j
	 */
	public String addZero(String number) {
		return StringPart.addZero(number);
	}

	/**
	 * 𔼊pJi֓
	 * @param input		Ώۉ
	 * @return	pJiϊ㕶
	 */
	public String toHankakuKana(String input) {
		return StringPart.toHankakuKana(input);
	}

	/**
	 * SpXy[X𔼊pXy[X֕ϊ
	 * @param input		SpXy[X܂܂镶
	 * @return	SpXy[X𔼊pXy[X֕ϊ̕
	 */
	public String to1byteSpace(String input) {
		return StringPart.to1byteSpace(input);
	}

	/*z֘A*/

	/**
	 * z񎟌ϊ
	 * @param ary1D		ϊꎟz
	 * @return	ϊ񎟌z
	 */
	public String[][] convArrayDimension(String[] ary1D) {
		return StringPart.convArrayDimension(ary1D);
	}

	/**
	 * z񎟌ϊ
	 * @param ary2D		ϊ񎟌z
	 * @return	ϊꎟz
	 */
	public String[] convArrayDimension(String[][] ary2D) {
		return StringPart.convArrayDimension(ary2D);
	}

	/**
	 * ꎟz񐶐
	 * @param str1		ΏۗvfP
	 * @param str2		ΏۗvfQ
	 * @return@z
	 */
	public String[] createArray(String str1, String str2) {
		return StringPart.createArray(str1, str2);
	}

	/**
	 * 󔒃v_E擾
	 * @return  󔒃v_Epz
	 */
	public String[][] getBlankArray() {
		return StringPart.getBlankArray();
	}

	/**
	 * ݐE/ސEXg擾
	 * @return ݐE/ސEXg
	 */
	public String[][] getRetirementFlagArrayAll() {
		// z̍쐬
		return addArrayFirstRowSpace(getRetirementFlagArray());
	}

	/**
	 * ݐE/ސEXg擾i󗓖j
	 * @return ݐE/ސEXg
	 */
	public String[][] getRetirementFlagArray() {
		return StringPart.getRetirementFlagArray();
	}

	/**
	 * ̎擾
	 * @param code  擾ΏۃR[h
	 * @return R[h
	 */
	public String getCodeName(String code, String[][] array) {
		return StringPart.getCodeName(code, array);
	}

	/**
	 * R[h擾
	 * @param name  擾ΏۃR[h
	 * @param array  擾Ώ۔z
	 * @return R[h
	 */
	public String getCodeValue(String name, String[][] array) {
		return StringPart.getCodeValue(name, array);
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	public String[][] getYearArray(int year) {
		return StringPart.getYearArray(year);
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @param former ߋ
	 * @param further 
	 * @return Nv_Epz
	 */
	public String[][] getYearArray(int year, int former, int further) {
		return StringPart.getYearArray(year, former, further);
	}

	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public String[][] getMonthArray() {
		return StringPart.getMonthArray();
	}

	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public String[][] getDayArray() {
		return StringPart.getDayArray();
	}

	/**
	 * ԃv_E擾
	 * @param hour          Jn
	 * @param minute        Jn
	 * @param count         f[^
	 * @param interval      f[^Ԋu()
	 * @param isValueMinute ݒtO(trueFvalue͕PʁAfalseFvalue͎ԕ)
	 * @return ԃv_Epz
	 */
	public String[][] getTimeArray(int hour, int minute, int count, int interval, boolean isValueMinute) {
		return StringPart.getTimeArray(hour, minute, count, interval, isValueMinute);
	}

	/**
	 * lv_E擾
	 * @param start		Jnl
	 * @param end		Il
	 * @param interval	Ԋu
	 * @return lv_Epz
	 */
	public String[][] getCountArray(int start, int end, int interval) {
		return StringPart.getCountArray(start, end, interval);
	}

	/**
	 * v_Es
	 * @param target Ώۃv_Ez
	 * @param value Ώۍsl
	 * @return v_E
	 */
	public String[][] removeArrayRow(String[][] target, String value) {
		return StringPart.removeArrayRow(target, value);
	}

	/**
	 * v_E̐擪sɋ󔒂ǉ
	 * @param target Ώۃv_Ez
	 * @return ǉv_E
	 */
	public String[][] addArrayFirstRowSpace(String[][] target) {
		return StringPart.addArrayFirstRowSpace(target);
	}

	/**
	 * v_E̐擪sɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public String[][] addArrayFirstRowValue(String[][] target, String code, String value) {
		return StringPart.addArrayFirstRowValue(target, code, value);
	}

	/**
	 * v_E̍ŏIsɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public String[][] addArrayLastRowValue(String[][] target, String code, String value) {
		return StringPart.addArrayLastRowValue(target, code, value);
	}

	/**
	 * 񎟌zꎟz֕ϊ
	 * @param ary Ώۓ񎟌z
	 * @param d INo.
	 * @return Iꎟz
	 * @throws Exception
	 */	
	public String[] separateArrayList(String[][] ary, int d) {
		return StringPart.separateArrayList(ary, d);
	}

	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public String[][] combineArray(String[][] frontarray, String[][] behindarray) {
		return StringPart.combineArray(frontarray, behindarray);
	}

	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param centerarray ns2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public String[][] combineArray(String[][] frontarray, String[][] centerarray, String[][] behindarray) {
		return StringPart.combineArray(frontarray, centerarray, behindarray);
	}

	/**
	 * z񓯎m̌
	 * @param list
	 * @return
	 */
	public String[][] combineArray(List<String[][]> list) {
		return StringPart.combineArray(list);
	}

	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public String[][] getExistenceArray() {
		return StringPart.getExistenceArray();
	}

	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public String[][] getExistenceShortArray() {
		return StringPart.getExistenceShortArray();
	}

	/**
	 * z`FbN
	 * @param ary1		Ώ۔zP
	 * @param ary2		Ώ۔zQ
	 * @return
	 * <p>
	 * z񂪈ꏏłtrueAłȂꍇfalse
	 * </p>
	 */
	public boolean checkArraysEquals(String[] ary1, String[] ary2) {
		return StringPart.checkArraysEquals(ary1, ary2);
	}

	/**
	 * ꎟzList
	 * @param array
	 * @return
	 */
	public List<String> arrayToList(String[] array) {
		return StringPart.arrayToList(array);
	}

	/*Ԋ֘A*/
	
	/**
	 * int̎ԂStringɕϊ
	 * @param time
	 * @return	string	ԁij
	 */
	public String convIntegerTimeToStringHour(int time) {
		return TimePart.convIntegerTimeToStringHour(time);
	}

	/**
	 * int̕Stringɕϊ
	 * @param time
	 * @return	string	ԁij
	 */
	public String convIntegerTimeToStringMinutes(int time) {
		return TimePart.convIntegerTimeToStringMinutes(time);
	}

	/**
	 * String̎ԂStringɕϊ
	 * @param time HH:MM
	 * @return HH
	 */
	public String convStringTimeToStringHour(String time) {
		return TimePart.convStringTimeToStringHour(time);
	}

	/**
	 * String̕Stringɕϊ
	 * @param time HH:MM
	 * @return MM
	 */
	public String convStringTimeToStringMinutes(String time) {
		return TimePart.convStringTimeToStringMinutes(time);
	}

	/**
	 * ϊiintStringj
	 * @param time int
	 * @return HH:MM
	 */
	public String convIntegerTimeToStringTime(int time) {
		return TimePart.convIntegerTimeToStringTime(time);
	}

	/**
	 * ϊiintStringj
	 * @param time int
	 * @return HHMM
	 */
	public String convIntegerTimeToJPTime(int time) {
		return TimePart.convIntegerTimeToJPTime(time);
	}

	/**
	 * ϊiStringintj
	 * @param time iHH:MMj
	 * @return int	i0̌oߕj
	 */
	public int convStringTimeToIntegerTime(String time) {
		return TimePart.convStringTimeToIntegerTime(time);
	}

	/**
	 * ϊiStringintj
	 * @param hour 
	 * @param min 
	 * @return int	i0̌oߕj
	 */
	public int convStringTimeToIntegerTime(String hour, String min) {
		return TimePart.convStringTimeToIntegerTime(hour, min);
	}

	/**
	 * ϊiStringStringj
	 * @param hour 
	 * @param min 
	 * @return	HH:mm
	 */
	public String convStringTimeFormatted(String hour, String min) {
		return TimePart.convStringTimeFormatted(hour, min);
	}

	/**
	 * ԕϊiintdoublej
	 * @param time int
	 * @return hh.mm <br>͂̂܂
	 * 				[] 651.05
	 */
	public double convIntegerTimeToDoubleTime(int time) {
		return TimePart.convIntegerTimeToDoubleTime(time);
	}

	/**
	 * ԕϊiintStringj
	 * <p>[] 901.5</p>
	 * <p>15Pʂ̏ꍇ̂ݗpĂB</p>
	 * @param time int
	 * @return hh.mm 
	 */
	public String convIntegerMinToStringHour(int time) {
		return TimePart.convIntegerMinToStringHour(time);
	}

	/**
	 * ԕϊiintStringj
	 * @param time int
	 * @return HHMM
	 */
	public String convIntegerTimeToJPHours(int time) {
		return TimePart.convIntegerTimeToJPHours(time);
	}

	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	public String getHourString(double hour) {
		return TimePart.getHourString(hour);
	}

	/*t֘A*/
	
	/**
	 * 擾
	 * @param date1 I
	 * @param date2 Jn
	 * @return (date1 - date2)
	 * @throws Exception
	 */
	public int getMonthRemainder(Date date1, Date date2) {
		return DatePart.getMonthRemainder(date1, date2);
	}

	/**
	 * 擾
	 * @param date1 I
	 * @param date2 Jn
	 * @return (date1 - date2)
	 * @throws Exception
	 */
	public long getDateRemainder(Date date1, Date date2) {
		return DatePart.getDateRemainder(date1, date2);
	}

	/**
	 * N
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addYear(Date date, int amount) {
		return DatePart.addYear(date, amount);
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addMonth(Date date, int amount) {
		return DatePart.addMonth(date, amount);
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addDay(Date date, int amount) {
		return DatePart.addDay(date, amount);
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addDay(Date date, String amount) {
		return DatePart.addDay(date, amount);
	}

	/**
	 * t擾iStringj
	 * @return tl
	 */
	public Date getInitialDate() { 
		return DatePart.getInitialDate();
	}

	/**
	 * VXet擾
	 * @return VXet
	 */
	public Date getSystemDate() {
		return DatePart.getSystemDate();
	}

	/**
	 * VXet擾
	 * @return VXet
	 */
	public Date getNowDate() {
		return DatePart.getNowDate();
	}

	/**
	 * 擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return 
	 */
	public Date getFirstDateOfMonth(String year, String month) {
		return DatePart.getFirstDateOfMonth(year, month);
	}

	/**
	 * 擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return 
	 */
	public Date getFirstDateOfMonth(int year, int month) {
		return DatePart.getFirstDateOfMonth(year, month);
	}

	/**
	 * ŏI擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return ŏI
	 */
	public Date getLastDateOfMonth(String year, String month) {
		return DatePart.getLastDateOfMonth(year, month);
	}

	/**
	 * ŏI擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return ŏI
	 */
	public Date getLastDateOfMonth(int year, int month) {
		return DatePart.getLastDateOfMonth(year, month);
	}

	/**
	 * N擾
	 * @param year  N
	 * @param month 
	 * @return N
	 */
	public Date getYearMonth(String year, String month) {
		return DatePart.getYearMonth(year, month);
	}

	/**
	 * Ԏ擾
	 * @param time 
	 * @return t
	 * @throws ParseException 
	 */
	public Date getTimeAsDate(String time) {
		return DatePart.getTimeAsDate(time);
	}

	/**
	 * I܂ވTԂ̊Jn擾
	 * @param date			I
	 * @param dayofweek		Jnj
	 * @return I܂ވTԂ̊Jn
	 */
	public Date getFirstDateOfWeek(Date date, int dayofweek) {
		return DatePart.getFirstDateOfWeek(date, dayofweek);
	}

	/**
	 * I܂ވTԂ̏I擾
	 * @param date			I
	 * @param dayofweek		Jnj
	 * @return I܂ވTԂ̏I
	 */
	public Date getLastDateOfWeek(Date date, int dayofweek) {
		return DatePart.getLastDateOfWeek(date, dayofweek);
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd	yyyy/mm/dd
	 * @return date
	 */
	public Date convStringDateToDate(String yyyymmdd) {
		return DatePart.convStringDateToDate(yyyymmdd);
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd yyyyMMdd
	 * @return date
	 */
	public Date convStringBaseDateToDate(String yyyymmdd) {
		return DatePart.convStringBaseDateToDate(yyyymmdd);
	}

	/**
	 * tϊ(StringString[])
	 * @param yyyymmdd Ώۓt(yyyy/mm/dd)
	 * @return tz
	 */
	public String[] convStringDateToArray(String yyyymmdd) {
		return DatePart.convStringDateToArray(yyyymmdd);
	}

	/**
	 * tϊiintDatej
	 * @param yyyymmdd
	 * @return date
	 */
	public Date convIntegerDateToDate(int yyyymmdd) {
		return DatePart.convIntegerDateToDate(yyyymmdd);
	}

	/**
	 * tϊ(intDate)
	 * @param year
	 * @param month
	 * @param day
	 * @return	Date	Ώ۔N
	 */
	public Date getDate(int year, int month, int day) {
		return DatePart.getDate(year, month, day); 
	}

	/**
	 * tϊ(StringDate)
	 * @param year
	 * @param month
	 * @param day
	 * @return	Date	Ώ۔N
	 */
	public Date getDate(String year, String month, String day) {
		return DatePart.getDate(year, month, day); 
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return date
	 */
	public Date convHyphenDateToDate(String yyyymmdd) {
		return DatePart.convHyphenDateToDate(yyyymmdd);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return yyyyNMd
	 */
	public String convHyphenDateToJPShortDate(String yyyymmdd) {
		return DatePart.convHyphenDateToJPShortDate(yyyymmdd);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return yyyyNMMdd
	 */
	public String convHyphenDateToJPDate(String yyyymmdd) {
		return DatePart.convHyphenDateToJPDate(yyyymmdd);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return yyyy/MM/dd
	 */
	public String convHyphenDateToFormatted(String yyyymmdd) {
		return DatePart.convHyphenDateToFormatted(yyyymmdd);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy/mm/dd
	 * @return yyyy-MM-dd
	 */
	public String convFormattedToHyphen(String yyyymmdd) {
		return DatePart.convFormattedToHyphen(yyyymmdd);
	}

	/**
	 * t擾iStringj
	 * @return	9999-99-99 00:00:00
	 */
	public String getDateTime() { 
		return DatePart.getDateTime();
	}

	/**
	 * t擾iStringj
	 * @param date
	 * @return 9999-99-99 99:99:99
	 */
	public String getDateTime(Date date) { 
		return DatePart.getDateTime(date);
	}

	/**
	 * Ԓf
	 * @param startDate		Jn
	 * @param endDate		I
	 * @param targetDate	Ώۓ
	 * @return
	 * <p>
	 * JnƏI̊ԂɑΏۓ݂ꍇtrueA<br>
	 * łȂꍇfalse
	 * </p>
	 */
	public boolean inPeriod(Date startDate, Date endDate, Date targetDate) {
		return DatePart.inPeriod(startDate, endDate, targetDate);
	}

	/**
	 * tϊ(intString[])
	 * @param date Ώۓt
	 * @return tz
	 */
	public String[] convIntegerDateToArray(int date) {
		return DatePart.convIntegerDateToArray(date);
	}

	/**
	 * tϊ(intString)
	 * @param date Ώۓt
	 * @return yyyyNmmdd
	 */
	public String convIntegerDateToJPDate(int date) {
		return DatePart.convIntegerDateToJPDate(date);
	}

	/**
	 * tϊ(intString)
	 * @param date Ώۓt
	 * @return yyyy/mm/dd
	 */
	public String convIntegerDateToStringFormatted(int date) {
		return DatePart.convIntegerDateToStringFormatted(date);
	}

	/**
	 * tϊ(Stringint)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyymmdd
	 */
	public int convStringDateToInteger(String yyyy, String mm, String dd) {
		return DatePart.convStringDateToInteger(yyyy, mm, dd);
	}

	/**
	 * tϊ(Stringint)
	 * @param yyyy-mm-dd
	 * @return yyyymmdd
	 */
	public int convStringDateToInteger(String yyyymmdd) {
		return DatePart.convStringDateToInteger(yyyymmdd);		
	}

	/**
	 * tϊ(intString)
	 * @param yyyy
	 * @param mm
	 * @param dd
	 * @return	string	tiyyyymmddj
	 */
	public String convIntegerToStringDate(int yyyy, int mm, int dd) {
		return DatePart.convIntegerToStringDate(yyyy, mm, dd);
	}

	/**
	 * tϊ(Dateint)
	 * @param date
	 * @return yyyymmdd
	 */
	public int convDateToInteger(Date date) {
		return DatePart.convDateToInteger(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyymmdd
	 */
	public String convDateToString(Date date) {
		return DatePart.convDateToString(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-mm
	 */
	public String convDateToStringYearMonth(Date date) {
		return DatePart.convDateToStringYearMonth(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-m
	 */
	public String convDateToStringYearMonthShort(Date date) {
		return DatePart.convDateToStringYearMonthShort(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-mm-dd
	 */
	public String convDateFormattedByHyphen(Date date) {
		return DatePart.convDateFormattedByHyphen(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy/mm/dd
	 */
	public String convDateFormatted(Date date) {
		return DatePart.convDateFormatted(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy,mm,dd
	 */
	public String convDateFormattedByComma(Date date) {
		return DatePart.convDateFormattedByComma(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date	date
	 * @return yyyyNMMdd
	 */
	public String convDateToFormatDateJP(Date date) {
		return DatePart.convDateToFormatDateJP(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date	date
	 * @return yyyyNMd
	 */
	public String convDateToFormatDateJPShort(Date date) {
		return DatePart.convDateToFormatDateJPShort(date);
	}

	/**
	 * tϊ(StringString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy/mm/dd
	 */
	public String convStringDateFormatted(String yyyy, String mm, String dd) {
		return DatePart.convStringDateFormatted(yyyy, mm, dd);
	}

	/**
	 * tϊ(StringString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy,mm,dd
	 */
	public String convStringDateFormattedByComma(String yyyy, String mm, String dd) {
		return DatePart.convStringDateFormattedByComma(yyyy, mm, dd);
	}

	/**
	 * tϊ(StringString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy-mm-dd
	 */
	public String convStringDateFormattedByHyphen(String yyyy, String mm, String dd) {
		return DatePart.convStringDateFormattedByHyphen(yyyy, mm, dd);
	}

	/**
	 * tϊ(intString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy-mm-dd
	 */
	public String convDateFormattedByHyphen(int yyyy, int mm, int dd) {
		return DatePart.convDateFormattedByHyphen(yyyy, mm, dd);
	}

}
